////////////////////////////////////////////////////////////////////////////////////////////////
//  FurShader
//     єVF[_[
//		Program by T.Ogura
//		iMME/{VF[_[ ͉P)
////////////////////////////////////////////////////////////////////////////////////////////////
// уVF[_[p@Rg[p[^

const float FurSupecularPower = 1;      // т͈̌
const float FurFlowScale = float2(500,1); // т̗
const float3 FurColor = float3(0.4, 0.3, 0.2); // т̐F

int FurShellCount = 10; // FurShell̖
const float FurLength = 1/40.0;  // FurShell̕

// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldMatrix              : WORLD;
float4x4 ViewMatrix               : VIEW;
float4x4 LightWorldViewProjMatrix : WORLDVIEWPROJECTION < string Object = "Light"; >;

float3   LightDirection    : DIRECTION < string Object = "Light"; >;
float3   CameraPosition    : POSITION  < string Object = "Camera"; >;

// }eAF
float4   MaterialDiffuse   : DIFFUSE  < string Object = "Geometry"; >;
float3   MaterialAmbient   : AMBIENT  < string Object = "Geometry"; >;
float3   MaterialEmmisive  : EMISSIVE < string Object = "Geometry"; >;
float3   MaterialSpecular  : SPECULAR < string Object = "Geometry"; >;
float    SpecularPower     : SPECULARPOWER < string Object = "Geometry"; >;
float3   MaterialToon      : TOONCOLOR;
// CgF
float3   LightDiffuse      : DIFFUSE   < string Object = "Light"; >;
float3   LightAmbient      : AMBIENT   < string Object = "Light"; >;
float3   LightSpecular     : SPECULAR  < string Object = "Light"; >;
static float4 DiffuseColor  = MaterialDiffuse  * float4(LightDiffuse, 1.0f);
static float3 AmbientColor  = saturate(MaterialAmbient  * LightAmbient + MaterialEmmisive);
static float3 SpecularColor = MaterialSpecular * LightSpecular;

bool     parthf;   // p[XyNeButO
bool     transp;   // tO
bool	 spadd;    // XtBA}bvZtO
#define SKII1    1500
#define SKII2    8000
#define Toon     3

// IuWFNg̃eNX`
texture ObjectTexture: MATERIALTEXTURE;
sampler ObjTexSampler = sampler_state {
    texture = <ObjectTexture>;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`iZtVhEONj

// VhEobt@̃TvB"register(s0)"Ȃ̂MMDs0gĂ邩
sampler DefSampler : register(s0);

struct BufferShadow_OUTPUT {
    float4 Pos      : POSITION;     // ˉeϊW
    float4 ZCalcTex : TEXCOORD0;    // Zl
    float2 Tex      : TEXCOORD1;    // eNX`
    float3 Normal   : TEXCOORD2;    // @
    float3 Eye      : TEXCOORD3;    // JƂ̑Έʒu
//    float2 SpTex    : TEXCOORD4;	 // XtBA}bveNX`W
    float4 Color    : COLOR0;       // fBt[YF
};

//-----------------------------------------------------------------------------------------------

int nFur;               // ݕ`撆FurShellԍ

texture2D fur_tex <
   string ResourceName = "a_tex_fur.tga";// FureNX`Bt̃eNX`͕̃{^͍ȂĂ
   int Miplevels = 1;
>;
sampler FurSampler = sampler_state {
   texture = <fur_tex>;
};

// _VF[_ i{`ĈߕsKvȌvZĂj
BufferShadow_OUTPUT Fur_VS(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0, uniform bool useToon)
{
    BufferShadow_OUTPUT Out = (BufferShadow_OUTPUT)0;

    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos+float4(Normal.xyz*FurLength,0)*nFur, WorldViewProjMatrix ); // FurShell@ɖc܂
    
    Out.Eye = CameraPosition - mul( Pos, WorldMatrix );
    Out.Normal = normalize( mul( Normal, (float3x3)WorldMatrix ) );
    Out.ZCalcTex = mul( Pos, LightWorldViewProjMatrix );
    // fBt[YF{ArGgF vZ
    Out.Color.rgb = AmbientColor;
    if ( !useToon ) {
        Out.Color.rgb += max(0,dot( Out.Normal, -LightDirection )) * DiffuseColor.rgb;
    }
    Out.Color.a = DiffuseColor.a;
    Out.Color = saturate( Out.Color );

    Out.Tex = Tex;// eNX`W
    return Out;
}
float ftime : TIME <bool SyncInEditMode=false;>;

float4 Fur_PS(BufferShadow_OUTPUT IN,  uniform bool useToon) : COLOR
{
    // XyLFvZ
    float3 HalfVector = normalize( normalize(IN.Eye) ); // т̌BD݂̖肩
 // float3 HalfVector = normalize( normalize(IN.Eye)  + -LightDirection );
    float3 Specular = 1.0-pow( max(0,dot( HalfVector, normalize(IN.Normal) )), FurSupecularPower ) * float3(1,1,1);
    
    float4 Color = IN.Color;
 	float4 TexColor =  tex2D( ObjTexSampler, IN.Tex ) * IN.Color;   // eNX`J[

    float2 furDir = float2(1.0, 0.0);
    Color.rgb = lerp( TexColor, FurColor, Specular.r); // Specular.rɂTexColor -> FurColorɕω
//    Color.rgb = lerp( float3(0,0,0), FurColor, Specular.r); // ŏ̔Łij͂
	
	// ˂˂Ȏ(GPUɒ)
	//float2 furDire = float2(sin(ftime+IN.Tex.x*20),cos(ftime+IN.Tex.y*40));
    //Color.rgb = float3(1.0-(furDir.x+1.0)/2.0,(furDir.x+1.0)/2.0,(furDir.y+1.0)/2.0) * Specular.r;
     
     // уeNX`ѕ̃At@BѐɍsقǔȂ
    
	Color.w = tex2D( FurSampler, IN.Tex- furDir / FurFlowScale * nFur).r * (1.0-nFur/(FurShellCount-1.0)); 
	
	// return Color; // Furɑ΂ZtVhE͂܂ǂȂ̂ŁAőł؂̂
    
    // eNX`Wɕϊ
    IN.ZCalcTex /= IN.ZCalcTex.w;
    float2 TransTexCoord;
    TransTexCoord.x = (1.0f + IN.ZCalcTex.x)*0.5f;
    TransTexCoord.y = (1.0f - IN.ZCalcTex.y)*0.5f;
	
    if( any( saturate(TransTexCoord) != TransTexCoord ) ) { 
        return Color;
    } else {
        float comp;
        if(parthf) {
            // ZtVhE mode2
            comp=1-saturate(max(IN.ZCalcTex.z-tex2D(DefSampler,TransTexCoord).r , 0.0f)*SKII2*TransTexCoord.y-0.3f);
        } else {
            // ZtVhE mode1
            comp=1-saturate(max(IN.ZCalcTex.z-tex2D(DefSampler,TransTexCoord).r , 0.0f)*SKII1-0.3f);
        }
        return Color * ( 0.7 +  comp *0.3) ; // ȅ͏Â
    }
}

// 11ԂWPbg̃f
// eNX`Kpꂽf̂ݑΉ
technique MainTecBS5  <
	string MMDPass = "object_ss";
	string subSet="12";
	bool UseTexture = true; bool UseToon = true;

       string Script =
	       "Pass = DrawObject;"
           "LoopByCount=FurShellCount;"
           "LoopGetIndex=nFur;"
           "Pass=Fur;"
           "LoopEnd=;";

> {
    // ñWPbgfBtHgVF[_[ŕ`悷
    pass DrawObject {
    }
    // уVF[_[
    pass Fur {
	    AlphaBlendEnable = TRUE;
		ZEnable      = TRUE;
		ZWriteEnable = false; // ѕDepthobt@XVȂ
		CULLMODE = CCW;

        VertexShader = compile vs_2_0 Fur_VS(true);
        PixelShader  = compile ps_2_0 Fur_PS(true);
    }
}
